<?php
require_once __DIR__ . '/../conexion.php';

function crearAlojamiento($nombre, $direccion)
{
    global $conexion;

    $sql = "INSERT INTO alojamientos (nombre,direccion) VALUES (?,?)";
    $stmt = $conexion->prepare($sql);

    if ($stmt === false) {
        return json_encode([
            "status" => "error",
            "message" => "Error en la preparación: " . $conexion->error
        ]);
    }

    $stmt->bind_param("ss", $nombre, $direccion);

    if ($stmt->execute()) {
        $id = $stmt->insert_id;
        $stmt->close();

        // Consultar el registro recién creado
        $result = $conexion->query("SELECT * FROM alojamientos WHERE id = $id");

        if ($result && $row = $result->fetch_assoc()) {
            return json_encode([
                "status" => "success",
                "message" => "Alojamiento creado correctamente",
                "data" => $row   // 👈 Devuelve SOLO un objeto
            ]);
        } else {
            return json_encode([
                "status" => "error",
                "message" => "Error al recuperar el alojamiento creado"
            ]);
        }
    } else {
        $error = $stmt->error;
        $stmt->close();

        return json_encode([
            "status" => "error",
            "message" => "Error al ejecutar: " . $error
        ]);
    }
}

function listarAlojamientos()
{
    global $conexion;

    $sql = "SELECT * FROM alojamientos";
    $stmt = $conexion->prepare($sql);

    if ($stmt === false) {
        return json_encode([
            "status" => "error",
            "message" => "Error en la preparación: " . $conexion->error
        ]);
    }

    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $alojamientos = [];

        while ($row = $result->fetch_assoc()) {
            $alojamientos[] = $row;
        }

        return json_encode([
            "status" => "success",
            "data" => $alojamientos
        ]);
    } else {
        return json_encode([
            "status" => "error",
            "message" => "Error al ejecutar: " . $stmt->error
        ]);
    }

    $stmt->close();
}

function eliminarAlojamiento($id)
{
    global $conexion;

    // Sentencia preparada para eliminar
    $sql = "DELETE FROM alojamientos WHERE id = ?";
    $stmt = $conexion->prepare($sql);

    if ($stmt === false) {
        return json_encode([
            "status" => "error",
            "message" => "Error en la preparación: " . $conexion->error
        ]);
    }

    // Vincular el parámetro (asumo que id es INT)
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            return json_encode([
                "status" => "success",
                "data" => "Alojamiento eliminado correctamente"
            ]);
        } else {
            return json_encode([
                "status" => "error",
                "message" => "No se encontró un alojamiento con ese ID"
            ]);
        }
    } else {
        return json_encode([
            "status" => "error",
            "message" => "Error al ejecutar: " . $stmt->error
        ]);
    }

    $stmt->close();
}

