
<?php
require_once __DIR__ . '/../conexion.php';

function crearCliente($nombres, $email, $dni, $telefono, $id = null)
{
    global $conexion;

    if (!empty($id)) {
        // Si llega un ID, actualizamos
        $stmt = $conexion->prepare("UPDATE clientes SET nombres=?, email=?, dni=?, telefono=? WHERE id=?");
        if ($stmt === false) {
            return json_encode([
                "status" => "error",
                "message" => "Error en la preparación (UPDATE): " . $conexion->error
            ]);
        }
        $stmt->bind_param("ssssi", $nombres, $email, $dni, $telefono, $id);

        if ($stmt->execute()) {
            $stmt->close();
            $result = $conexion->query("SELECT * FROM clientes WHERE id = $id");
            $row = $result->fetch_assoc();

            return json_encode([
                "status" => "success",
                "message" => "Cliente actualizado correctamente",
                "data" => $row
            ]);
        } else {
            $error = $stmt->error;
            $stmt->close();
            return json_encode([
                "status" => "error",
                "message" => "Error al actualizar: " . $error
            ]);
        }

    } else {
        // Si no llega ID, insertamos
        $stmt = $conexion->prepare("INSERT INTO clientes (nombres,email,dni,telefono) VALUES (?,?,?,?)");
        if ($stmt === false) {
            return json_encode([
                "status" => "error",
                "message" => "Error en la preparación (INSERT): " . $conexion->error
            ]);
        }
        $stmt->bind_param("ssss", $nombres, $email, $dni, $telefono);

        if ($stmt->execute()) {
            $id = $stmt->insert_id;
            $stmt->close();

            $result = $conexion->query("SELECT * FROM clientes WHERE id = $id");
            $row = $result->fetch_assoc();

            return json_encode([
                "status" => "success",
                "message" => "Cliente creado correctamente",
                "data" => $row
            ]);
        } else {
            $error = $stmt->error;
            $stmt->close();
            return json_encode([
                "status" => "error",
                "message" => "Error al insertar: " . $error
            ]);
        }
    }
}


function listarClientes()
{
    global $conexion;

    $sql = "SELECT * FROM clientes";
    $stmt = $conexion->prepare($sql);

    if ($stmt === false) {
        return json_encode([
            "status" => "error",
            "message" => "Error en la preparación: " . $conexion->error
        ]);
    }

    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $clientes = [];

        while ($row = $result->fetch_assoc()) {
            $clientes[] = $row;
        }

        return json_encode([
            "status" => "success",
            "data" => $clientes
        ]);
    } else {
        return json_encode([
            "status" => "error",
            "message" => "Error al ejecutar: " . $stmt->error
        ]);
    }

    $stmt->close();
}

function eliminarCliente($id)
{
    global $conexion;

    // Sentencia preparada para eliminar
    $sql = "DELETE FROM clientes WHERE id = ?";
    $stmt = $conexion->prepare($sql);

    if ($stmt === false) {
        return json_encode([
            "status" => "error",
            "message" => "Error en la preparación: " . $conexion->error
        ]);
    }

    // Vincular el parámetro (asumo que id es INT)
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            return json_encode([
                "status" => "success",
                "data" => "Cliente eliminado correctamente"
            ]);
        } else {
            return json_encode([
                "status" => "error",
                "message" => "No se encontró un Cliente con ese ID"
            ]);
        }
    } else {
        return json_encode([
            "status" => "error",
            "message" => "Error al ejecutar: " . $stmt->error
        ]);
    }

    $stmt->close();
}
function buscarCliente($dni)
{
    global $conexion;

    // Preparar la sentencia
    $sql = "SELECT * FROM clientes WHERE dni = ?";
    $stmt = $conexion->prepare($sql);

    if ($stmt === false) {
        return json_encode([
            "status" => "error",
            "message" => "Error en la preparación: " . $conexion->error
        ]);
    }

    // Vincular el parámetro (dni como string)
    $stmt->bind_param("s", $dni);

    // Ejecutar
    if (!$stmt->execute()) {
        return json_encode([
            "status" => "error",
            "message" => "Error al ejecutar: " . $stmt->error
        ]);
    }

    // Obtener resultados
    $resultado = $stmt->get_result();
    if ($resultado->num_rows > 0) {
        $cliente = $resultado->fetch_assoc();
        $stmt->close();
        return json_encode([
            "status" => "success",
            "data" => $cliente
        ]);
    } else {
        $stmt->close();
        return json_encode([
            "status" => "error",
            "message" => "No se encontró ningún cliente con ese DNI"
        ]);
    }
}
