<?php
require_once __DIR__ . '/../conexion.php';



function listasReglas()
{
    global $conexion;

    $sql = "SELECT * FROM configuraciones";
    $stmt = $conexion->prepare($sql);

    if ($stmt === false) {
        return json_encode([
            "status" => "error",
            "message" => "Error en la preparación: " . $conexion->error
        ]);
    }

    if ($stmt->execute()) {
        $result = $stmt->get_result(); // obtener resultados
        $conf = [];

        while ($row = $result->fetch_assoc()) {
            $conf[] = $row;
        }

        $stmt->close(); // cerrar statement antes de devolver
        return json_encode([
            "status" => "success",
            "data" => $conf
        ]);
    } else {
        $stmt->close();
        return json_encode([
            "status" => "error",
            "message" => "Error al ejecutar: " . $stmt->error
        ]);
    }
}

function guardarReglas($regla)
{
    global $conexion;

    // Primero eliminar todas las reglas existentes
    $sqlDelete = "DELETE FROM configuraciones";
    if (!$conexion->query($sqlDelete)) {
        return json_encode([
            "status" => "error",
            "message" => "Error al eliminar reglas anteriores: " . $conexion->error
        ]);
    }

    // Luego insertar la nueva regla
    $sqlInsert = "INSERT INTO configuraciones (reglas) VALUES (?)";
    $stmt = $conexion->prepare($sqlInsert);

    if ($stmt === false) {
        return json_encode([
            "status" => "error",
            "message" => "Error en la preparación: " . $conexion->error
        ]);
    }

    $stmt->bind_param("s", $regla);

    if ($stmt->execute()) {
        $idInsertado = $stmt->insert_id;
        $stmt->close();

        return json_encode([
            "status" => "success",
            "message" => "Regla guardada correctamente",
            "insert_id" => $idInsertado
        ]);
    } else {
        $stmt->close();
        return json_encode([
            "status" => "error",
            "message" => "Error al ejecutar: " . $stmt->error
        ]);
    }
}


