<?php
require_once __DIR__ . '/../conexion.php';
error_reporting(0); // opcional en producción para evitar notices/warnings
function crearReserva(
    $cliente,
    $entidadAlojamiento,
    $fechaLlegada,
    $horaLlegada,
    $fechaSalida,
    $horaSalida,
    $cantidadAdultos,
    $cantidadNinos,
    $traeMascotas,
    $importeTotal,
    $adelanto,
    $observaciones,
    $entidadCliente,
    $notaCliente,
    $estadoReserva,
    $id = null
) {
    global $conexion;
    $idCliente = !empty($cliente["id"]) && is_numeric($cliente["id"]) ? intval($cliente["id"]) : null;

    // Capturar todos los errores y warnings
    set_error_handler(function ($errno, $errstr, $errfile, $errline) {
        echo json_encode([
            "status" => "error",
            "message" => "Error PHP: [$errno] $errstr in $errfile on line $errline"
        ]);
        exit;
    });

    $traeMascotas = $traeMascotas ? 1 : 0;

    // Convertir entidadCliente a JSON string para guardar
    if (is_array($entidadCliente) || is_object($entidadCliente)) {
        $entidadCliente = json_encode($entidadCliente);
    }

    try {
        if (!empty($id) && intval($id) > 0) {
            $conexion->begin_transaction();
            // Actualizar reserva existente
            $entidadCliente = crearCliente($cliente["nombres"], $cliente["email"], $cliente["dni"], $cliente["telefono"], $idCliente);

            $stmt = $conexion->prepare("UPDATE reservas 
                SET entidadAlojamiento=?, fechaLlegada=?, horaLlegada=?, fechaSalida=?, horaSalida=?, 
                    cantidadAdultos=?, cantidadNinos=?, traeMascotas=?, importeTotal=?, adelanto=?, 
                    observaciones=?, entidadCliente=?, notaCliente=?, estadoReserva=? 
                WHERE id_reserva=?");

            if ($stmt === false) {
                throw new Exception("Error preparación UPDATE: " . $conexion->error);
            }

            $stmt->bind_param(
                "issssiiidissssi",
                $entidadAlojamiento,
                $fechaLlegada,
                $horaLlegada,
                $fechaSalida,
                $horaSalida,
                $cantidadAdultos,
                $cantidadNinos,
                $traeMascotas,
                $importeTotal,
                $adelanto,
                $observaciones,
                $entidadCliente,
                $notaCliente,
                $estadoReserva,
                $id
            );

            if (!$stmt->execute()) {
                throw new Exception("Error al actualizar: " . $stmt->error);
            }

            $stmt->close();
            $conexion->commit();
            $result = $conexion->query("SELECT * FROM reservas WHERE id_reserva = $id");
            $row = $result->fetch_assoc();

            return json_encode([
                "status" => "success",
                "message" => "Reserva actualizada correctamente",
                "data" => $row
            ]);
        } else {
            // Insertar nueva reserva
            $entidadCliente = crearCliente($cliente["nombres"], $cliente["email"], $cliente["dni"], $cliente["telefono"], $idCliente);

            $stmt = $conexion->prepare("INSERT INTO reservas 
                (entidadAlojamiento, fechaLlegada, horaLlegada, fechaSalida, horaSalida, 
                 cantidadAdultos, cantidadNinos, traeMascotas, importeTotal, adelanto, 
                 observaciones, entidadCliente, notaCliente, estadoReserva) 
                VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)");

            if ($stmt === false) {
                throw new Exception("Error preparación INSERT: " . $conexion->error);
            }

            $stmt->bind_param(
                "issssiiidissss",
                $entidadAlojamiento,
                $fechaLlegada,
                $horaLlegada,
                $fechaSalida,
                $horaSalida,
                $cantidadAdultos,
                $cantidadNinos,
                $traeMascotas,
                $importeTotal,
                $adelanto,
                $observaciones,
                $entidadCliente,
                $notaCliente,
                $estadoReserva
            );

            if (!$stmt->execute()) {
                throw new Exception("Error al insertar: " . $stmt->error);
            }

            $id = $stmt->insert_id;
            $stmt->close();
            $conexion->commit();
            $result = $conexion->query("SELECT * FROM reservas WHERE id_reserva = $id");
            $row = $result->fetch_assoc();

            return json_encode([
                "status" => "success",
                "message" => "Reserva creada correctamente",
                "data" => $row
            ]);
        }
    } catch (Exception $e) {
        $conexion->rollback();
        return json_encode([
            "status" => "error",
            "message" => $e->getMessage()
        ]);
    } finally {
        restore_error_handler();
    }
}


function crearCliente($nombres, $email, $dni, $telefono, $id = null)
{
    global $conexion;

    try {
        // Validar unicidad: email, dni y teléfono
        if ($id) {
            $check = $conexion->prepare("SELECT id FROM clientes WHERE (email=? OR dni=? OR telefono=?) AND id!=?");
            $check->bind_param("sssi", $email, $dni, $telefono, $id);
        } else {
            $check = $conexion->prepare("SELECT id FROM clientes WHERE email=? OR dni=? OR telefono=?");
            $check->bind_param("sss", $email, $dni, $telefono);
        }

        $check->execute();
        $resCheck = $check->get_result();
        if ($resCheck->num_rows > 0) {
            throw new Exception("Ya existe un cliente con este email, DNI o teléfono");
        }
        $check->close();

        if (!empty($id)) {
            // Actualizar cliente existente
            $stmt = $conexion->prepare("UPDATE clientes SET nombres=?, email=?, dni=?, telefono=? WHERE id=?");
            if ($stmt === false) {
                throw new Exception("Error preparación UPDATE: " . $conexion->error);
            }
            $stmt->bind_param("ssssi", $nombres, $email, $dni, $telefono, $id);
            if (!$stmt->execute()) {
                throw new Exception("Error al actualizar: " . $stmt->error);
            }
            $stmt->close();

            // Retornar el ID existente
            return $id;
        } else {
            // Insertar nuevo cliente
            $stmt = $conexion->prepare("INSERT INTO clientes (nombres,email,dni,telefono) VALUES (?,?,?,?)");
            if ($stmt === false) {
                throw new Exception("Error preparación INSERT: " . $conexion->error);
            }
            $stmt->bind_param("ssss", $nombres, $email, $dni, $telefono);
            if (!$stmt->execute()) {
                throw new Exception("Error al insertar: " . $stmt->error);
            }

            $nuevoId = $stmt->insert_id; // <-- ID del cliente insertado
            $stmt->close();

            return $nuevoId;
        }
    } catch (Exception $e) {
        throw new Exception($e->getMessage());
    }
}




function buscarReservas($id)
{
    global $conexion;

    $sql = "SELECT * FROM reservas as r INNER JOIN alojamientos as a ON r.entidadAlojamiento=a.id INNER JOIN clientes as c ON r.entidadCliente=c.id WHERE r.entidadAlojamiento=$id AND r.estadoReserva!='Reserva Anulada'";
    $stmt = $conexion->prepare($sql);

    if ($stmt === false) {
        return json_encode([
            "status" => "error",
            "message" => "Error en la preparación: " . $conexion->error
        ]);
    }

    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $reservas = [];

        while ($row = $result->fetch_assoc()) {
            $reservas[] = $row;
        }

        return json_encode([
            "status" => "success",
            "data" => $reservas
        ]);
    } else {
        return json_encode([
            "status" => "error",
            "message" => "Error al ejecutar: " . $stmt->error
        ]);
    }

    $stmt->close();
}


function eliminarReserva($id)
{
    global $conexion;

    $sql = "DELETE FROM reservas WHERE id_reserva = ?";
    $stmt = $conexion->prepare($sql);

    if ($stmt === false) {
        return json_encode([
            "status" => "error",
            "message" => "Error en la preparación: " . $conexion->error
        ]);
    }

    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            return json_encode([
                "status" => "success",
                "data" => "Reserva eliminada correctamente"
            ]);
        } else {
            return json_encode([
                "status" => "error",
                "message" => "No se encontró una Reserva con ese ID"
            ]);
        }
    } else {
        return json_encode([
            "status" => "error",
            "message" => "Error al ejecutar: " . $stmt->error
        ]);
    }

    $stmt->close();
}
