<?php
$accion = $_GET['accion'] ?? '';

$data = file_get_contents("php://input");

$json = json_decode($data, true);

if ($json !== null) {
    $nombre = $json['nombre'] ?? "";
    $direccion = $json['direccion'] ?? "";
    $id = $json['id'] ?? "";
}

switch ($accion) {
    case '':
        // Página HTML normal
        require 'views/home.php';
        break;

    case 'crear-alojamiento':
        require_once 'controllers/alojamiento.php';
        header('Content-Type: application/json');
        echo crearAlojamiento($nombre, $direccion);
        break;

    case 'listar-alojamientos':
        require_once 'controllers/alojamiento.php';
        header('Content-Type: application/json');
        echo listarAlojamientos();
        break;
    case 'eliminar-alojamiento':
        require_once 'controllers/alojamiento.php';
        header('Content-Type: application/json');
        echo eliminarAlojamiento($id);
        break;

    case 'listar-clientes':
        require_once 'controllers/cliente.php';
        header('Content-Type: application/json');
        echo listarClientes();
        break;
    case 'buscar-cliente':
        require_once 'controllers/cliente.php';
        header('Content-Type: application/json');
        $dni = $json['dni'] ?? "";

        echo buscarCliente($dni);
        break;
    case 'crear-cliente':
        require_once 'controllers/cliente.php';
        $nombres = $json['nombres'] ?? "";
        $email = $json['email'] ?? "";
        $dni = $json['dni'] ?? "";
        $telefono = $json['telefono'] ?? "";
        $id = $json['id'] ?? "";

        header('Content-Type: application/json');
        echo crearCliente($nombres, $email, $dni, $telefono, $id);
        break;

    case 'eliminar-cliente':
        require_once 'controllers/cliente.php';
        header('Content-Type: application/json');
        $id = $json['id'] ?? "";
        echo eliminarCliente($id);
        break;
    case 'buscar-reservas':
        require_once 'controllers/reserva.php';
        header('Content-Type: application/json');
        $id = $json['id'] ?? "";
        echo buscarReservas($id);
        break;
    case 'crear-reserva':
        require_once 'controllers/reserva.php';
        $cliente =$json['entidadCliente'];
        $entidadAlojamiento = $json['entidadAlojamiento']['id'] ?? 0;
        $fechaLlegada       = $json['fechaLLegada'] ?? "";
        $horaLlegada        = $json['horaLlegada'] ?? "";
        $fechaSalida        = $json['fechaSalida'] ?? "";
        $horaSalida         = $json['horaSalida'] ?? "";
        $cantidadAdultos    = $json['cantidadAdultos'] ?? 1;
        $cantidadNinos      = $json['cantidadNinos'] ?? 0;
        $traeMascotas       = $json['traeMascotas'] ?? 0;
        $importeTotal       = $json['importeTotal'] ?? 0.00;
        $adelanto           = $json['adelanto'] ?? 0.00;
        $observaciones      = $json['observaciones'] ?? "";
        $entidadCliente     = $json['entidadCliente']['id'] ?? 0;
        $notaCliente        = $json['notaCliente'] ?? "";
        $estadoReserva      = $json['estadoReserva'] ?? "";
        $id                 = $json['id'] ?? null;

        header('Content-Type: application/json');
        echo crearReserva(
            $cliente,
            $entidadAlojamiento,
            $fechaLlegada,
            $horaLlegada,
            $fechaSalida,
            $horaSalida,
            $cantidadAdultos,
            $cantidadNinos,
            $traeMascotas,
            $importeTotal,
            $adelanto,
            $observaciones,
            $entidadCliente,
            $notaCliente,
            $estadoReserva,
            $id
        );
        break;

    case 'reglas':
        require_once 'controllers/conf.php';
        header('Content-Type: application/json');
        echo listasReglas();
        break;
    case 'reglas-guardar':
        require_once 'controllers/conf.php';
        header('Content-Type: application/json');
        $regla = $json["reglas"];
        echo guardarReglas($regla);
        break;
    default:
        http_response_code(404);
        require 'views/404.php';
        break;
}
